
	.importzp vt0, vt1
	.importzp mt0, mt1, mt2, mt3, mt4, mt5, mt6, mt7
	.importzp mb0, mb1, mb2, mb3, mb4, mb5, mb6, mb7
	.importzp mx0, mx1, mx2, mx3
	.importzp _v0, _v1, _a0, _a1

	; table addresses
	mlo = $200000
	mhi = $210000

	.segment "CODE"

	.macro AS
	sep #$20
	.A8
	.endmacro

	.macro AL
	rep #$20
	.A16
	.endmacro

	.macro XS
	sep #$10
	.I8
	.endmacro

	.macro XL
	rep #$10
	.I16
	.endmacro

	.macro AXS
	sep #$30
	.A8
	.I8
	.endmacro

	.macro AXL
	rep #$30
	.A16
	.I16
	.endmacro

	.P816
	.A16
	.I16
	.export _multiply_65816_setup_1632
_multiply_65816_setup_1632:
	AXL
	lda #$0010 ; put tables at $00100000
	ldx #$ffff

	;.for i=0,i<8,i=i+1
	.repeat 8,i
		stz mb0+(i*4)+0
		sta mb0+(i*4)+2
		.if i>3
			stx mt0+(i*4)+0
			sta mt0+(i*4)+2
		;.fi
		.endif
		.if i<7
			ina
			.if i<4
				stz mt0+(i*4)+0
				sta mt0+(i*4)+2
			;.fi
			.endif
			ina
		;.fi
		.endif
	;.next
	.endrepeat

	ldx #$0000
	stz vt0+0
	stz vt0+2
	stz vt1+0

loop1:
	txa
	lsr
	clc
	adc vt0+0
	sta vt0+0
	lda #$0000
	adc vt0+2
	sta vt0+2

	AS
	txy
	lda vt0+0
	sta [mb0],y
	sta [mt4],y
	lda vt0+1
	sta [mb1],y
	sta [mt5],y
	lda vt0+2
	sta [mb2],y
	sta [mt6],y
	lda vt0+3
	sta [mb3],y
	sta [mt7],y
	AL

	stx vt1+0
	sec
	lda #$ffff
	sbc vt1+0
	tay

	AS
	lda vt0+0
	sta [mb4],y
	lda vt0+1
	sta [mb5],y
	lda vt0+2
	sta [mb6],y
	lda vt0+3
	sta [mb7],y
	AL

	inx
	bne loop1

loop2:
	txa
	lsr
	ora #$8000
	clc
	adc vt0+0
	sta vt0+0
	lda #$0000
	adc vt0+2
	sta vt0+2

	AS
	txy
	lda vt0+0
	sta [mt0],y
	lda vt0+1
	sta [mt1],y
	lda vt0+2
	sta [mt2],y
	lda vt0+3
	sta [mt3],y
	AL

	inx
	bne loop2

	; return
	AXS
	rts

	.P816
	.A16
	.I16
	.export _multiply_65816_setup_8
_multiply_65816_setup_8:
	AXL
	ldx #$0000

loop3:
	ldy #$0000

	stz vt0+0
	txa
	xba
	and #$00ff
	sta vt1+0

loop4:
	AS
	lda vt0+0
	sta mlo,x
	lda vt0+1
	sta mhi,x
	AL

	clc
	lda vt0+0
	adc vt1+0
	sta vt0+0

	inx
	iny
	cpy #$0100
	bne loop4
	cpx #$0000
	bne loop3

	; return
	AXS
	rts

	.P816
	.A16
	.I16
	.export _multiply_65816_u32
_multiply_65816_u32:
	; LO * LO
	ldy _a1+0
	lda _a0+0

	sta mb0 ;set zp adresses
	sta mb1
	sta mb2
	sta mb3
	eor #$ffff
	sta mb4
	sta mb5
	sta mb6
	sta mb7

	AS
	sec
	lda [mb0],y
	sbc [mb4],y
	sta _v0+0
	lda [mb1],y
	sbc [mb5],y
	sta _v0+1
	lda [mb2],y
	sbc [mb6],y
	sta _v0+2
	lda [mb3],y
	sbc [mb7],y
	sta _v0+3
	AL

	; LO * HI
	ldy _a1+2

	AS
	sec
	lda [mb0],y
	sbc [mb4],y
	sta vt0+0
	lda [mb1],y
	sbc [mb5],y
	sta vt0+1
	lda [mb2],y
	sbc [mb6],y
	sta vt0+2
	lda [mb3],y
	sbc [mb7],y
	sta vt0+3
	AL

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+2
	adc #0
	sta _v0+4

	; HI * LO
	ldy _a1+0
	lda _a0+2

	sta mb0 ;set zp adresses
	sta mb1
	sta mb2
	sta mb3
	eor #$ffff
	sta mb4
	sta mb5
	sta mb6
	sta mb7

	AS
	sec
	lda [mb0],y
	sbc [mb4],y
	sta vt0+0
	lda [mb1],y
	sbc [mb5],y
	sta vt0+1
	lda [mb2],y
	sbc [mb6],y
	sta vt0+2
	lda [mb3],y
	sbc [mb7],y
	sta vt0+3
	AL

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+2
	adc _v0+4
	sta _v0+4
	lda #0
	adc #0
	sta _v0+6

	; HI * HI
	ldy _a1+2

	AS
	sec
	lda [mb0],y
	sbc [mb4],y
	sta vt0+0
	lda [mb1],y
	sbc [mb5],y
	sta vt0+1
	lda [mb2],y
	sbc [mb6],y
	sta vt0+2
	lda [mb3],y
	sbc [mb7],y
	sta vt0+3
	AL

	; PROD
	clc
	lda vt0+0
	adc _v0+4
	sta _v0+4
	lda vt0+2
	adc _v0+6
	sta _v0+6

	; return
	rts

	.P816
	.A16
	.I16
	.export _multiply_65816_u16
_multiply_65816_u16:
	; LO * LO
	ldy _a1+0
	lda _a0+0

	sta mb0 ;set zp adresses
	sta mb1
	sta mb2
	sta mb3
	eor #$ffff
	sta mb4
	sta mb5
	sta mb6
	sta mb7

	AS
	sec
	lda [mb0],y
	sbc [mb4],y
	sta _v0+0
	lda [mb1],y
	sbc [mb5],y
	sta _v0+1
	lda [mb2],y
	sbc [mb6],y
	sta _v0+2
	lda [mb3],y
	sbc [mb7],y
	sta _v0+3
	AL

	; return
	rts

	.P816
	.A16
	.I16
	.export _multiply_65816_u8
_multiply_65816_u8:
	AS
	lda _a0+0
	xba
	lda _a1+0
	tax

	lda mlo,x
	sta _v0+0
	lda mhi,x
	sta _v0+1
	AL

	; return
	rts
