
	.importzp vt0, vt1
	.importzp mt0, mt1, mt2, mt3, mt4, mt5, mt6, mt7
	.importzp mb0, mb1, mb2, mb3, mb4, mb5, mb6, mb7
	.importzp mx0, mx1, mx2, mx3
	.importzp _v0, _v1, _a0, _a1

	.segment "CODE"

	.P02
	.export _multiply_6502_setup
_multiply_6502_setup:
	lda #$c0 ; put tables at $c000
	ldy #$00
	ldx #$ff
	clc

	;.for i=0,i<4,i=i+1
	.repeat 4,i
		sty mx0+(i*2)+0
		sta mx0+(i*2)+1
		.if i>1
			stx mt0+(i*4)+0
			sta mt0+(i*4)+1
		;.fi
		.endif
		.if i<3
			adc #1
			.if i<2
				sty mt0+(i*4)+0
				sta mt0+(i*4)+1
			;.fi
			.endif
			adc #1
		;.fi
		.endif
	;.next
	.endrepeat

	ldx #$00
	stx vt0+0
	stx vt0+1
	stx vt1+0

loop1:
	txa
	lsr
	clc
	adc vt0+0
	sta vt0+0
	lda #$00
	adc vt0+1
	sta vt0+1

	txa
	tay
	lda vt0+0
	sta (mx0),y
	sta (mt2),y
	lda vt0+1
	sta (mx1),y
	sta (mt3),y

	stx vt1+0
	sec
	lda #$ff
	sbc vt1+0
	tay

	lda vt0+0
	sta (mx2),y
	lda vt0+1
	sta (mx3),y

	inx
	bne loop1

loop2:
	txa
	lsr
	ora #$80
	clc
	adc vt0+0
	sta vt0+0
	lda #$00
	adc vt0+1
	sta vt0+1

	txa
	tay
	lda vt0+0
	sta (mt0),y
	lda vt0+1
	sta (mt1),y

	inx
	bne loop2

	; return
	rts

	.P02
	.export _multiply_6502_u32
_multiply_6502_u32:
	; ----- 1

	; A0_0 * A1_0 (1-0)
	ldy _a1+0
	lda _a0+0

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta _v0+0
	lda (mx1),y
	sbc (mx3),y
	sta _v0+1

	; A0_0 * A1_1 (2-1)
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+1
	sta _v0+1
	lda vt0+1
	adc #0
	sta _v0+2

	; A0_0 * A1_2 (3-2)
	ldy _a1+2

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+1
	adc #0
	sta _v0+3

	; A0_0 * A1_3 (4-3)
	ldy _a1+3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+3
	sta _v0+3
	lda vt0+1
	adc #0
	sta _v0+4

	; ----- 2

	; A0_1 * A1_0 (4-1)
	ldy _a1+0
	lda _a0+1

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+1
	sta _v0+1
	lda vt0+1
	adc _v0+2
	sta _v0+2
	lda _v0+3
	adc #0
	sta _v0+3
	lda _v0+4
	adc #0
	sta _v0+4

	; A0_1 * A1_1 (4-2)
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+1
	adc _v0+3
	sta _v0+3
	lda _v0+4
	adc #0
	sta _v0+4

	; A0_1 * A1_2 (5-3)
	ldy _a1+2

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+3
	sta _v0+3
	lda vt0+1
	adc _v0+4
	sta _v0+4
	lda #0
	adc #0
	sta _v0+5

	; A0_1 * A1_3 (5-4)
	ldy _a1+3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+4
	sta _v0+4
	lda vt0+1
	adc _v0+5
	sta _v0+5

	; ----- 3

	; A0_2 * A1_0 (5-2)
	ldy _a1+0
	lda _a0+2

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+1
	adc _v0+3
	sta _v0+3
	lda _v0+4
	adc #0
	sta _v0+4
	lda _v0+5
	adc #0
	sta _v0+5

	; A0_2 * A1_1 (6-3)
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+3
	sta _v0+3
	lda vt0+1
	adc _v0+4
	sta _v0+4
	lda _v0+5
	adc #0
	sta _v0+5
	lda #0
	adc #0
	sta _v0+6

	; A0_2 * A1_2 (6-4)
	ldy _a1+2

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+4
	sta _v0+4
	lda vt0+1
	adc _v0+5
	sta _v0+5
	lda _v0+6
	adc #0
	sta _v0+6

	; A0_2 * A1_3 (6-5)
	ldy _a1+3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+5
	sta _v0+5
	lda vt0+1
	adc _v0+6
	sta _v0+6

	; ----- 4

	; A0_3 * A1_0 (7-3)
	ldy _a1+0
	lda _a0+3

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+3
	sta _v0+3
	lda vt0+1
	adc _v0+4
	sta _v0+4
	lda _v0+5
	adc #0
	sta _v0+5
	lda _v0+6
	adc #0
	sta _v0+6
	lda #0
	adc #0
	sta _v0+7

	; A0_3 * A1_1 (7-4)
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+4
	sta _v0+4
	lda vt0+1
	adc _v0+5
	sta _v0+5
	lda _v0+6
	adc #0
	sta _v0+6
	lda _v0+7
	adc #0
	sta _v0+7

	; A0_3 * A1_2 (7-5)
	ldy _a1+2

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+5
	sta _v0+5
	lda vt0+1
	adc _v0+6
	sta _v0+6
	lda _v0+7
	adc #0
	sta _v0+7

	; A0_3 * A1_3 (7-6)
	ldy _a1+3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+6
	sta _v0+6
	lda vt0+1
	adc _v0+7
	sta _v0+7

	; return
	rts

	.P02
	.export _multiply_6502_u16
_multiply_6502_u16:
	; LO * LO
	ldy _a1+0
	lda _a0+0

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta _v0+0
	lda (mx1),y
	sbc (mx3),y
	sta _v0+1

	; LO * HI
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+1
	sta _v0+1
	lda vt0+1
	adc #0
	sta _v0+2

	; HI * LO
	ldy _a1+0
	lda _a0+1

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+1
	sta _v0+1
	lda vt0+1
	adc _v0+2
	sta _v0+2
	lda #0
	adc #0
	sta _v0+3

	; HI * HI
	ldy _a1+1

	sec
	lda (mx0),y
	sbc (mx2),y
	sta vt0+0
	lda (mx1),y
	sbc (mx3),y
	sta vt0+1

	; PROD
	clc
	lda vt0+0
	adc _v0+2
	sta _v0+2
	lda vt0+1
	adc _v0+3
	sta _v0+3

	; return
	rts

	.P02
	.export _multiply_6502_u8
_multiply_6502_u8:
	; LO * LO
	ldy _a1+0
	lda _a0+0

	sta mx0 ;set zp adresses
	sta mx1
	eor #$ff
	sta mx2
	sta mx3

	sec
	lda (mx0),y
	sbc (mx2),y
	sta _v0+0
	lda (mx1),y
	sbc (mx3),y
	sta _v0+1

	; return
	rts
