
	.importzp vt0, vt1
	.importzp mt0, mt1, mt2, mt3, mt4, mt5, mt6, mt7
	.importzp mb0, mb1, mb2, mb3, mb4, mb5, mb6, mb7
	.importzp mx0, mx1, mx2, mx3
	.importzp _v0, _v1, _a0, _a1
	.importzp dx0

	; table addresses
	dq = $300000
	dr = $310000

	.segment "CODE"

	.macro AS
	sep #$20
	.A8
	.endmacro

	.macro AL
	rep #$20
	.A16
	.endmacro

	.macro XS
	sep #$10
	.I8
	.endmacro

	.macro XL
	rep #$10
	.I16
	.endmacro

	.macro AXS
	sep #$30
	.A8
	.I8
	.endmacro

	.macro AXL
	rep #$30
	.A16
	.I16
	.endmacro

	.P816
	.A16
	.I16
	.export _divide_65816_setup_1632
_divide_65816_setup_1632:
	rts

	.P816
	.A16
	.I16
	.export _divide_65816_setup_8
_divide_65816_setup_8:
	AXL
	stz _a1+0

loop1:
	lda _a1+1
	sta _a0+0
	jsr _divide_65816_u8_slow

	AS
	ldx _a1+0
	lda _v0+0
	sta dq,x
	lda _v1+0
	sta dr,x
	AL

	inc _a1+0
	bne loop1

	; return
	AXS
	rts

	.P816
	.A16
	.I16
	.export _divide_65816_u32
_divide_65816_u32:
	; v0 = a0 / a1, v1 = a0 % a1

	; copy dividend
	lda _a0 + 0
	sta _v0 + 0
	lda _a0 + 2
	sta _v0 + 2

	; clear remainder
	stz _v1 + 0
	stz _v1 + 2

	; set binary count to 32
	ldx #32

	; shift into partial dividend
loop32:
	asl _v0 + 0
	rol _v0 + 2
	rol _v1 + 0
	rol _v1 + 2

	; subtract divisor
	sec
	lda _v1 + 0
	sbc _a1 + 0
	sta vt0 + 0
	lda _v1 + 2
	sbc _a1 + 2

	; jump if divisor didn't fit
	bcc no_fit32

	; store new remainder
	sta _v1 + 2
	lda vt0 + 0
	sta _v1 + 0

	; increase quotient
	inc _v0 + 0

	; loop
no_fit32:
	dex
	bne loop32

	; return
	rts

	.P816
	.A16
	.I16
	.export _divide_65816_u16
_divide_65816_u16:
	; v0 = a0 / a1, v1 = a0 % a1

	; copy dividend
	lda _a0 + 0
	sta _v0 + 0

	; clear remainder
	stz _v1 + 0

	; set binary count to 16
	ldx #16

	; shift into partial dividend
loop16:
	asl _v0 + 0
	rol _v1 + 0

	; subtract divisor
	sec
	lda _v1 + 0
	sbc _a1 + 0

	; jump if divisor didn't fit
	bcc no_fit16

	; store new remainder
	sta _v1 + 0

	; increase quotient
	inc _v0 + 0

	; loop
no_fit16:
	dex
	bne loop16

	; return
	rts

	.P816
	.A16
	.I16
	.export _divide_65816_u8_slow
_divide_65816_u8_slow:
	AXS
	; v0 = a0 / a1, v1 = a0 % a1

	; copy dividend
	lda _a0 + 0
	sta _v0 + 0

	; clear remainder
	stz _v1 + 0

	; set binary count to 8
	ldx #8

	; shift into partial dividend
loop8:
	asl _v0 + 0
	rol _v1 + 0

	; subtract divisor
	sec
	lda _v1 + 0
	sbc _a1 + 0

	; jump if divisor didn't fit
	bcc no_fit8

	; store new remainder
	sta _v1 + 0

	; increase quotient
	inc _v0 + 0

	; loop
no_fit8:
	dex
	bne loop8

	; return
	AXL
	rts

	.P816
	.A16
	.I16
	.export _divide_65816_u8
_divide_65816_u8:
	AS
	; v0 = a0 / a1, v1 = a0 % a1

	lda _a0+0
	xba
	lda _a1+0
	tax

	lda dq,x
	sta _v0+0
	lda dr,x
	sta _v1+0

	; return
	AL
	rts
